/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomRegisters;
import noppes.npcs.blocks.BlockBorder;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.Availability;

public class TileBorder
extends TileNpcEntity
implements Predicate,
ITickable {
    public Availability availability = new Availability();
    public boolean creative = false;
    public int height = 10;
    public int rotation = 0;
    public String message = "availability.areaNotAvailable";

    public boolean apply(Object ob) {
        return this.isEntityApplicable((Entity)ob);
    }

    private boolean checkPlayer(EntityPlayer player, int startY) {
        if (player.field_71075_bZ.field_75098_d && !this.creative || this.availability.isAvailable(player)) {
            return false;
        }
        BlockPos newPos = new BlockPos(this.field_174879_c.func_177958_n(), startY, this.field_174879_c.func_177952_p());
        if (this.rotation == 2) {
            newPos = newPos.func_177968_d();
        } else if (this.rotation == 0) {
            newPos = newPos.func_177978_c();
        } else if (this.rotation == 1) {
            newPos = newPos.func_177974_f();
        } else if (this.rotation == 3) {
            newPos = newPos.func_177976_e();
        }
        for (int i = startY - this.field_174879_c.func_177956_o(); !(i >= this.height || this.field_145850_b.func_175623_d(newPos) && this.field_145850_b.func_175623_d(newPos.func_177984_a())); ++i) {
            newPos = newPos.func_177984_a();
        }
        player.func_70634_a((double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o(), (double)newPos.func_177952_p() + 0.5);
        if (!this.message.isEmpty()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(this.message, new Object[0]), true);
        }
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74768_a("Rotation", this.rotation);
        compound.func_74768_a("Height", this.height);
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound compound) {
        this.rotation = compound.func_74762_e("Rotation");
        this.height = compound.func_74762_e("Height");
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean isEntityApplicable(Entity var1) {
        return var1 instanceof EntityPlayerMP || var1 instanceof EntityEnderPearl;
    }

    public void readExtraNBT(NBTTagCompound compound) {
        this.availability.load(compound.func_74775_l("BorderAvailability"));
        this.rotation = compound.func_74762_e("BorderRotation");
        this.height = compound.func_74762_e("BorderHeight");
        this.message = compound.func_74779_i("BorderMessage");
        this.creative = compound.func_74767_n("Bordercreative");
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readExtraNBT(compound);
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, CustomRegisters.border.func_176223_P().func_177226_a((IProperty)BlockBorder.ROTATION, (Comparable)Integer.valueOf(this.rotation)));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 1; i < this.height && i < 3; ++i) {
            if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(i)).func_177230_c() instanceof BlockBorder)) continue;
            return;
        }
        List list = new ArrayList();
        try {
            list = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + this.height + 1), (double)(this.field_174879_c.func_177952_p() + 1)), (Predicate)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity entity : list) {
            if (entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                if (!(pearl.func_85052_h() instanceof EntityPlayer)) continue;
                entity.field_70128_L = this.checkPlayer((EntityPlayer)pearl.func_85052_h(), (int)(entity.field_70163_u + 0.5));
                continue;
            }
            if (!(entity instanceof EntityPlayer)) continue;
            this.checkPlayer((EntityPlayer)entity, (int)(entity.field_70163_u + 0.5));
        }
    }

    public void writeExtraNBT(NBTTagCompound compound) {
        compound.func_74782_a("BorderAvailability", (NBTBase)this.availability.save(new NBTTagCompound()));
        compound.func_74768_a("BorderRotation", this.rotation);
        compound.func_74768_a("BorderHeight", this.height);
        compound.func_74778_a("BorderMessage", this.message);
        compound.func_74757_a("Bordercreative", this.creative);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        this.writeExtraNBT(compound);
        return super.func_189515_b(compound);
    }
}

